#include<string.h>
#include<stdio.h>
#include<stdlib.h>
#include<math.h>

char sbuf[256];

int soundFreq[8*11];

void initSoundFreq()
{
	int middleC=261.63,i;
	double freq;

	for(i=0;i<88;i++) {
		freq=exp(log(middleC)+(i-44)*log(880/440)/12.0);
		
		soundFreq[i]=111860/freq;	/* Translate to tone generator */
	}
}

int translateNote(char *c)
{
	int octave=44;
	int tone=0;
	int pos=0;
	
	switch(c[pos] | 32) {
	case 'a':
		tone=53;
		break;
	case 'b':
		tone=55;
		break;
	case 'c':
		tone=44;
		break;
	case 'd':
		tone=46;
		break;
	case 'e':
		tone=48;
		break;
	case 'f':
		tone=49;
		break;
	case 'g':
		tone=51;
		break;
	}
	/* printf(";detected base tone %d\n",tone); */
	if((c[pos++]&32)==0) tone-=12;
	while(c[pos++]==c[0]) {
		if(c[0]&32) {	/* lowercase goes up */
			tone+=12;
		} else {
			tone-=12;
		}
	}
	pos--;
	/*printf(";detected octave tone %d\n",tone);*/
	switch(c[pos]) {
	case '-':
		tone--;
		pos++;
		/*printf(";detected flat %d\n",tone);*/
		break;
	case '#':
		tone++;
		pos++;
		/*printf(";detected sharp %d\n",tone);*/
		break;
	}
	/* printf(";mapped to tone %d\n",tone); */
	if(tone<0 || tone>87) {
		printf(";Internal error!!\n");
		tone=44;
	}
	return soundFreq[tone];
}

int main(argv,argc)
{
	int d,i;
	char cbuf[16],*c,*s;
	int tempo=60; /* 60 beats per minute */
	int channel=3;	/* 1 to 3 are music, 0 is noise */
	int vol=4;	/* attenuatino */
	int freq=440;	/* Frequency */
	int repeat=0;	/* Repeat song forever */
	int note=1;	/* Note number */

	initSoundFreq();

	/* Output assembly source for music based on humdrum input */
	for(i=0;i<11;i++) {
		printf("N%dON\tEQU\t1\n",i);
	}
	printf(";Music score data\n");
	printf("Song1	EQU	1\n");
	printf("Notes%d:\n",note++);
	printf("\tIF\tN%dON\n",note-1);

	while( gets(sbuf) ) {
		int i,duration;
		c=cbuf;
		s=sbuf;
		

		switch(s[0]) {
		case '*':
			if(s[1]=='-') {
				/* end of song token */
				printf(";End of song\n");
				printf("\tDB\t%03xh\n",channel*64+16+repeat*8);

				printf("\tENDIF\n");

				printf("Song%d	EQU	%d\n",note,note);
				printf("Notes%d:\n",note++);
				printf("\tIF\tN%dON\n",note-1);
			}
		case '.':
		case '!':
		case '=':
			printf(";%s\n",s);
			continue;
		}
		printf(";%s\n",s);
		if(s[0]=='(' || s[0]=='[' || s[0]=='{') s++;
		sscanf(s,"%d%s",&d,c);
		/*printf(";Scanned '%s', %d\n",c,d);*/
		duration=60*60/d/tempo;
		if(c[0]=='.') {
			/*printf(";'.' means duration from %d to %d\n",duration,duration*3/2);*/
			duration=duration*3/2;
			c++;
		}
		if(c[0]=='r') {
			/*printf(";1/%d rest note\n",d);*/
			printf("\tDB\t%03xh\n",channel*64+32+duration);
		} else if((c[0]>='a' && c[0]<='g') || (c[0]>='A' && c[0]<='G')) {
			freq=translateNote(c);	/* Translate to inverted frequency */
			/*printf(";1/%d %c note.\n",d,c[0]);*/
			printf("\tDB\t%03xh,",channel*64+0);
			printf("%03xh,%03xh,",freq&255,(freq>>8)+16*vol);
			printf("%03xh\n",duration);
		} else {
			printf(";error %c!=(%d,%d..%d)\n",c[0],'r','a','g');
		}
	}
	printf("\tENDIF\n");
	printf(";End of song\n");
	printf("\tDB\t%03xh\n",channel*64+16+repeat*8);
	printf("SoundDataCount	EQU	7\n");
	printf("SongDataArea\tEQU\t7200h\n");
	printf(";LenSongData\t10*SoundDataCount+1	;7 data areas\n");
	printf("SongCount\tEQU\t%d\n",note);
	printf("SoundAddrs:\n");
	for(i=1;i<note;i++) {
		printf("\tDW\tNotes%d\n",i);
		printf("\tDW\tSongDataArea\n");
	}
	return 0;
}

